attribute vec2 coord_xz;
attribute float coord_y;
attribute float alpha;

uniform mat4 mvp, mv;

varying vec3 f_view_pos;
varying float f_alpha;
varying float f_alpha_adapt;

#ifdef QUALITY_HIGH_NORMAL
attribute vec3 normal;
varying vec3 f_view_normal;
#endif


void main(void)
{
	vec4 coord = vec4(coord_xz.x, coord_y, coord_xz.y, 1.0);
	gl_Position = mvp * coord;

	f_view_pos = vec3(mv * coord);
	f_alpha = alpha;

	const float alphaAdaptMult = 2.0;
	f_alpha_adapt = min(1.0, alpha*alphaAdaptMult);

#ifdef QUALITY_HIGH_NORMAL
	f_view_normal = vec3(mv * vec4(normal, 0.0));
#endif
}
